<?php
/**
 * Core: The i18n class
 *
 * @link        https://oxyprops.com
 *
 * @package     OxyProps
 * @subpackage  Core
 * @author      Cédric Bontems <cedric@thewebforge.dev>
 * @since       1.4.0
 * @copyright   Copyright (c) 2022, Cédric Bontems
 * @license     https://www.gnu.org/licenses/gpl-2.0.html  GPLv2 or later
 */

namespace OxyProps\Inc;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * OxyProps\Inc\I18n.
 *
 * Handles translations.
 *
 * @since 1.4.0 Creation.
 * @since 1.5.0 Include Singleton Trait and get rid of base controller.
 * @author Cédric Bontems <cedric@thewebforge.dev>
 */
class I18n {

	use Singleton;

	/**
	 * Initialize I18n class.
	 *
	 * Called by the constructor. It retreives and populates all the class properties.
	 *
	 * @see https://developer.wordpress.org/reference/hooks/plugins_loaded/
	 *
	 * @since 1.4.0 Creation.
	 * @author Cédric Bontems <cedric@thewebforge.dev>
	 *
	 * @return void
	 */
	public function register(): void {
		add_action( 'plugins_loaded', array( $this, 'load_oxyprops_translated_strings' ) );
	}

	/**
	 * Loads Oxyprops text domain.
	 *
	 * @see https://developer.wordpress.org/reference/functions/load_plugin_textdomain/
	 *
	 * @since 1.4.0 Creation.
	 * @author Cédric Bontems <cedric@thewebforge.dev>
	 *
	 * @return void
	 */
	public function load_oxyprops_translated_strings():void {
		$slug = Init::get_instance( 'oxyprops' )->get_slug();
		load_plugin_textdomain( 'oxyprops', false, $slug . '/languages' );
	}
}
